/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
 */
#ifndef ARM_ADP_H
#define ARM_ADP_H

__attribute__((always_inline)) inline float _mm_vector_add_ps(__m128 a)
{
    return vaddvq_f32(a.vect_f32);
}

__attribute__((always_inline)) inline __m128d _mm_fmadd_pd_mine(__m128d a, __m128d b, __m128d c)
{
    __m128d dst;
    dst.vect_f64 = vfmaq_f64(c.vect_f64, a.vect_f64, b.vect_f64);
    return dst;
}

__attribute__((always_inline)) inline __m128 _mm_fmadd_ps_mine(__m128 a, __m128 b, __m128 c)
{
    __m128 dst;
    dst.vect_f32 = vfmaq_f32(c.vect_f32, a.vect_f32, b.vect_f32);
    return dst;
}

__attribute__((always_inline)) inline __m128d _mm_fnmadd_pd_mine(__m128d a, __m128d b, __m128d c)
{
    __m128d dst;
    dst.vect_f64 = vfmsq_f64(c.vect_f64, a.vect_f64, b.vect_f64);
    return dst;
}

__attribute__((always_inline)) inline __m128 _mm_fnmadd_ps_mine(__m128 a, __m128 b, __m128 c)
{
    __m128 dst;
    dst.vect_f32 = vfmsq_f32(c.vect_f32, a.vect_f32, b.vect_f32);
    return dst;
}

#endif
